import pygame
import random
import time
import tkinter as tk

pygame.init()
pygame.mixer.init()

# -----------------------------
# Sounds
# -----------------------------
# Sprungsound laden
jump_sound = pygame.mixer.Sound("../sounds/fg/jump.wav")
jump_sound.set_volume(0.1)
# Coins-Sound
coin_sound = pygame.mixer.Sound("../sounds/fg/coins.wav")
coin_sound.set_volume(0.5)

pause_sound = pygame.mixer.Sound("../sounds/fg/menue.wav")
pause_sound.set_volume(3.0)

game_over_sound = pygame.mixer.Sound("../sounds/fg/gameover.wav")
game_over_sound.set_volume(10.0)

# -----------------------------
# Startdialog
# -----------------------------
# Der Startdialog wurde auskommentiert (optional)

# -----------------------------
# SCREEN
# -----------------------------
SCREEN_WIDTH = 800
SCREEN_HEIGHT = 600
screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
pygame.display.set_caption("Elias 2D Game – LEVEL 2")

# -----------------------------
# FARBEN
# -----------------------------
BLUE = (0, 0, 255)        # Wasser (tödlich)
GREEN = (0, 255, 0)
RED = (255, 0, 0)
WHITE = (255, 255, 255)
BROWN = (120, 50, 7)
STONE = (40, 40, 40)
BG = (70, 110, 255)
GOLD = (255, 215, 0)

# -----------------------------
# SPIELER
# -----------------------------
player_x = 100
player_y = 400
player_size = 50
VELOCITY = 3
GRAVITY = 0.5
velocity_y = 0
is_jumping = False
JUMP_STRENGTH = 10
lives = 3

# -----------------------------
# GEGNER
# -----------------------------
enemy_x = 600
enemy_y = 400
enemy_size = 30
ENEMY_VELOCITY = 2
enemy_direction = 1

# -----------------------------
# MÜNZEN
# -----------------------------
coin_count = 0
def münze(x, y, value):
    return (x, y, 15, value)

coins = [
    münze(250, 420, 1),
    münze(550, 370, 3),
    münze(900, 450, 5),
    münze(1250, 420, 2),
    münze(1600, 380, 4),
]

# -----------------------------
# KISTEN
# -----------------------------
chests = []
def makeChest(x, y, coinsin):
    chest = {
        "x": x,
        "y": y,
        "width": 32,
        "height": 32,
        "coins": coinsin,
        "collected": False,
        "rect": pygame.Rect(x, y, 32, 32)
    }
    chests.append(chest)

makeChest(700, 400, 5)
makeChest(1400, 450, 10)

# -----------------------------
# TÜR
# -----------------------------
door_image = pygame.image.load("images/tür.jpg").convert_alpha()
door_image = pygame.transform.scale(door_image, (50, 100))
door_rect = pygame.Rect(2050, 400, 50, 100)  # Ziel am Ende der Landschaft

# -----------------------------
# PARTIKEL
# -----------------------------
class Particle:
    def __init__(self, x, y, color):
        self.x = x
        self.y = y
        self.color = color
        self.size = random.randint(3,5)
        self.life = random.randint(10,30)
        self.velocity_x = random.uniform(-1,1)
        self.velocity_y = random.uniform(-1,1)
    def move(self):
        self.x += self.velocity_x
        self.y += self.velocity_y
        self.life -= 1
    def draw(self, screen):
        if self.life > 0:
            pygame.draw.circle(screen, self.color, (int(self.x), int(self.y)), self.size)

particles = []
def create_particles(x, y, color):
    for _ in range(10):
        particles.append(Particle(x, y, color))

# -----------------------------
# BLÖCKE
# -----------------------------
PIXEL_SIZE = 5
GRASS_HEIGHT = 10

def makeblock(screen, x, y, size, color):
    num_pixels = size // PIXEL_SIZE
    for px in range(num_pixels):
        for py in range(num_pixels):
            draw_x = x + px * PIXEL_SIZE
            draw_y = y + py * PIXEL_SIZE
            if color == GREEN:
                pixel_color = GREEN if py * PIXEL_SIZE < GRASS_HEIGHT else BROWN
            else:
                pixel_color = color
            pygame.draw.rect(screen, pixel_color, (draw_x, draw_y, PIXEL_SIZE, PIXEL_SIZE))

# -----------------------------
# PAUSE-MENÜ
# -----------------------------
def open_pause_menu():
    pause_sound.play()
    pause_root = tk.Tk()
    pause_root.title("Pause")
    tk.Label(pause_root, text="PAUSE", font=("Arial", 18)).pack(pady=10)
    def resume():
        pause_root.destroy()
    def exit_game():
        pause_root.destroy()
        pygame.quit()
        quit()
        pause_sound.play()
    tk.Button(pause_root, text="Weiter", width=20, command=resume).pack(pady=5)
    tk.Button(pause_root, text="Exit", width=20, command=exit_game).pack(pady=5)
    pause_root.mainloop()
    pause_sound.play()

# -----------------------------
# KOLLISION
# -----------------------------
def check_collision(x, y, blocks):
    for block in blocks:
        bx, by, bsize, bcolor, triggered = block
        if x + player_size > bx and x < bx + bsize:
            if y + player_size >= by and y + player_size <= by + 10:
                return block
    return None

def draw_lives(screen, lives):
    font = pygame.font.SysFont('Arial', 30)
    text = font.render(f"Leben: {lives}", True, WHITE)
    screen.blit(text, (10, 10))

def move_enemy():
    global enemy_x, enemy_direction
    enemy_x += ENEMY_VELOCITY * enemy_direction
    if enemy_x <= 0 or enemy_x >= 2050 - enemy_size:
        enemy_direction *= -1

def push_enemy():
    global enemy_x
    if abs(player_x - enemy_x) < 30:
        enemy_x += 10
        if enemy_x > 2050:
            enemy_x = -enemy_size

# -----------------------------
# BLOCKLISTE für Level2
# -----------------------------
blocks = []
level_length = 2000
x = 0
while x < level_length:
    platform_y = random.choice([450, 500, 520])
    if x % 500 < 140:
        blocks.append((x, 580, 140, BLUE, False))  # Wasser
    else:
        if x % 300 == 0:
            blocks.append((x, platform_y, 70, RED, False))  # Rote Plattformen
        else:
            blocks.append((x, platform_y, 70, GREEN, False))  # Grüne Plattformen
    x += 70

# -----------------------------
# SCROLLING VARIABLEN
# -----------------------------
scroll_x = 0
SCROLL_SPEED = 40 / 60  # 40 px pro Sekunde bei 60 FPS

# -----------------------------
# HAUPTSCHLEIFE
# -----------------------------
clock = pygame.time.Clock()
running = True
while running:
    dt = clock.tick(60) / 1000
    scroll_x += SCROLL_SPEED

    keys = pygame.key.get_pressed()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_p:
                open_pause_menu()
            if event.key == pygame.K_f:
                push_enemy()
            if event.key == pygame.K_w and not is_jumping:
                velocity_y = -JUMP_STRENGTH
                is_jumping = True
                jump_sound.play()

    # Spielerbewegung
    if keys[pygame.K_a]:
        player_x -= VELOCITY
    if keys[pygame.K_d]:
        player_x += VELOCITY

    # Schwerkraft
    player_y += velocity_y
    velocity_y += GRAVITY

    # Kollisionsprüfung
    block = check_collision(player_x + scroll_x, player_y, blocks)
    if block:
        bx, by, bsize, bcolor, triggered = block
        if bcolor == RED and not triggered:
            lives -= 1
            blocks[blocks.index(block)] = (bx, by, bsize, GREEN, True)  # Plattform als getriggert markieren
            player_y = by - player_size
            velocity_y = 0
            is_jumping = False
        elif bcolor == BLUE:
            lives -= 1
            player_y = 400
            player_x = 100
            velocity_y = 0
            is_jumping = False
        else:
            player_y = by - player_size
            velocity_y = 0
            is_jumping = False

    move_enemy()

    player_rect = pygame.Rect(player_x, player_y, player_size, player_size)

    # Münzen sammeln (MIT SOUND)
    for coin in coins[:]:
        cx, cy, cr, value = coin
        rect = pygame.Rect(cx - scroll_x, cy - cr, cr*2, cr*2)
        if player_rect.colliderect(rect):
            coins.remove(coin)
            coin_count += value
            coin_sound.play()

    # Kisten öffnen (MIT SOUND)
    for chest in chests:
        rect = chest["rect"].copy()
        rect.x -= scroll_x
        if not chest["collected"] and player_rect.colliderect(rect):
            chest["collected"] = True
            coin_count += chest["coins"]
            coin_sound.play()
            create_particles(rect.centerx, rect.centery, GOLD)

    # Tür erreichen
    door_draw_rect = door_rect.copy()
    door_draw_rect.x -= scroll_x
    if player_rect.colliderect(door_draw_rect) and keys[pygame.K_RETURN]:
        open_pause_menu()

    # Partikel bewegen
    for particle in particles[:]:
        particle.move()
        if particle.life <= 0:
            particles.remove(particle)

    # Zeichnen
    screen.fill(BG)

    for bx, by, bsize, bcolor, triggered in blocks:
        makeblock(screen, bx - scroll_x, by, bsize, bcolor)

    for cx, cy, cr, value in coins:
        pygame.draw.circle(screen, GOLD, (cx - scroll_x, cy), cr)

    for chest in chests:
        if not chest["collected"]:
            pygame.draw.rect(screen, BROWN, (chest["x"] - scroll_x, chest["y"], chest["width"], chest["height"]))

    screen.blit(door_image, door_draw_rect)

    for particle in particles:
        particle.draw(screen)

    pygame.draw.rect(screen, RED, (player_x, player_y, player_size, player_size))
    draw_lives(screen, lives)

    font = pygame.font.SysFont('Arial', 30)
    text = font.render(f"Coins: {coin_count}", True, WHITE)
    screen.blit(text, (10, 50))

    if lives <= 0:
        game_over_sound.play()
        pygame.display.flip()
        pygame.time.delay(2000)
        running = False

    pygame.display.flip()

pygame.quit()

