import pygame
import random
import tkinter as tk
import time

pygame.init()
pygame.mixer.init()

# -----------------------------
# SOUNDS
# -----------------------------
jump_sound = pygame.mixer.Sound("../sounds/fg/jump.wav")
jump_sound.set_volume(0.1)
# Coins-Sound
coin_sound = pygame.mixer.Sound("../sounds/fg/coins.wav")
coin_sound.set_volume(0.5)

pause_sound = pygame.mixer.Sound("../sounds/fg/menue.wav")
pause_sound.set_volume(3.0)

game_over_sound = pygame.mixer.Sound("../sounds/fg/gameover.wav")
game_over_sound.set_volume(10.0)

hit_sound = pygame.mixer.Sound("sounds/fg/hit.wav")
hit_sound.set_volume(0.4)

# -----------------------------
# SCREEN
# -----------------------------
SCREEN_WIDTH = 800
SCREEN_HEIGHT = 600
screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
pygame.display.set_caption("Elias 2D Game – LEVEL 3")

# -----------------------------
# COLORS
# -----------------------------
BLUE = (0, 0, 255)
GREEN = (0, 255, 0)
WHITE = (255, 255, 255)
BG = (70, 110, 255)
GOLD = (255, 215, 0)
RED = (255, 0, 0)

# -----------------------------
# PLAYER ANIMATION BILDER LADEN
# -----------------------------
player_run_images = [
    pygame.transform.scale(pygame.image.load("images/player_run1.png").convert_alpha(), (50, 50)),
    pygame.transform.scale(pygame.image.load("images/player_run2.png").convert_alpha(), (50, 50)),
    pygame.transform.scale(pygame.image.load("images/player_run3.png").convert_alpha(), (50, 50))
]

player_jump_image = pygame.transform.scale(pygame.image.load("images/player_jump.png").convert_alpha(), (50, 50))

player_idle_image = pygame.transform.scale(pygame.image.load("images/player_idle.png").convert_alpha(), (50, 50))

player_frame_index = 0
player_animation_timer = 0

# -----------------------------
# Var def:
# -----------------------------
player_x = 100
player_y = 400
player_size = 50

shop_x = 1000
shop_y = 400
shop_size = 50
shop_size_ = 50

border_x = 2650
border_y = 0
border_size = 20
border_size_ = 800

VELOCITY = 3
GRAVITY = 0.5
velocity_y = 0
is_jumping = False
JUMP_STRENGTH = 15
lives = 3

has_weapon = False
has_better_jump = False
coin_count = 10

# -----------------------------
# ENEMY
# -----------------------------
villain_img = pygame.image.load("images/villain.jpg").convert_alpha()
villain_img = pygame.transform.scale(villain_img, (50, 50))

enemies = [
    {"x": 600, "y": 400, "hp": 3, "dir": 1},
    {"x": 1200, "y": 380, "hp": 3, "dir": -1},
    {"x": 1800, "y": 420, "hp": 4, "dir": 1},
]

# -----------------------------
# COINS
# -----------------------------
def münze(x, y, value):
    return (x, y, 15, value)

coins = []

# Level-Länge
level_length = 2600

# 30 Münzen verteilen
for i in range(20):
    x = random.randint(100, level_length - 50)
    y = random.choice([360, 380, 400, 420, 440])
    value = random.randint(6, 7)
    coins.append(münze(x, y, value))

# -----------------------------
# DOOR
# -----------------------------
door_image = pygame.image.load("images/tür.jpg").convert_alpha()
door_image = pygame.transform.scale(door_image, (50, 100))
door_rect = pygame.Rect(2600, 400, 50, 100)

# -----------------------------
# BLOCKS (Level 3, alle grün/blau)
# -----------------------------
blocks = []
x = 0
while x < level_length:
    platform_y = random.choice([420, 470, 520])
    if x % 450 < 140:
        blocks.append((x, 580, 140, BLUE, False))
    else:
        blocks.append((x, platform_y, 70, GREEN, False))
    x += 70

# -----------------------------
# COLLISION
# -----------------------------
def check_collision(x, y):
    for b in blocks:
        bx, by, bs, bc, trig = b
        if x + player_size > bx and x < bx + bs:
            if y + player_size >= by and y + player_size <= by + 10:
                return b
    return None

# -----------------------------
# SHOP
# -----------------------------
def open_shop():
    global coin_count, has_weapon, has_better_jump, JUMP_STRENGTH

    shop = tk.Tk()
    shop.title("SHOP")

    tk.Label(shop, text="SHOP", font=("Arial", 18)).pack(pady=10)
    tk.Label(shop, text=f"Coins: {coin_count}").pack(pady=5)

    def buy_sword():
        global coin_count, has_weapon
        if coin_count >= 10 and not has_weapon:
            coin_count -= 10
            has_weapon = True
            shop.destroy()

    def buy_better_jump():
        global coin_count, has_better_jump, JUMP_STRENGTH
        if coin_count >= 3 and not has_better_jump:
            coin_count -= 3
            has_better_jump = True
            JUMP_STRENGTH += 3
            shop.destroy()

    tk.Button(shop, text="Schwert kaufen (10 Coins)", command=buy_sword).pack(pady=5)
    tk.Button(shop, text="Bessere Sprungkraft (3 Coins)", command=buy_better_jump).pack(pady=5)
    tk.Button(shop, text="Schließen", command=shop.destroy).pack(pady=5)

    shop.mainloop()

# -----------------------------
# PAUSE MENU
# -----------------------------
def open_pause_menu():
    pause = tk.Tk()
    pause.title("Pause")

    tk.Label(pause, text="PAUSE", font=("Arial", 18)).pack(pady=10)

    tk.Button(pause, text="Weiter", width=20, command=pause.destroy).pack(pady=5)
    tk.Button(pause, text="SHOP", width=20, command=open_shop).pack(pady=5)
    tk.Button(pause, text="Exit", width=20, command=exit).pack(pady=5)

    pause.mainloop()

# -----------------------------
# WAFFE BILD
# -----------------------------
sword_img = pygame.image.load("images/sword.png").convert_alpha()
sword_img = pygame.transform.scale(sword_img, (50, 50))

# -----------------------------
# MAIN LOOP
# -----------------------------

print("Setlich springen!")
time.sleep(2.6)

scroll_x = 0
clock = pygame.time.Clock()
running = True

while running:
    clock.tick(60)
    scroll_x += 0.7

    keys = pygame.key.get_pressed()

    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_p:
                pause_sound.play()
                open_pause_menu()
                pause_sound.play()
            if event.key == pygame.K_w and not is_jumping:
                velocity_y = -JUMP_STRENGTH
                is_jumping = True
                jump_sound.play()
            if event.key == pygame.K_f:
                shop_rect_screen = pygame.Rect(shop_x - scroll_x, shop_y, shop_size, shop_size_)
                if player_rect.colliderect(shop_rect_screen.inflate(50, 50)):
                    pause_sound.play()
                    open_shop()

    # -----------------------------
    # UNSICHTBARE WAND HINTER DER TÜR
    # -----------------------------
    border_rect = pygame.Rect(door_rect.x + door_rect.width, 0, 20, SCREEN_HEIGHT)  # unsichtbare Wand rechts hinter der Tür

    # -----------------------------
    # Im MAIN LOOP nach Movement prüfen
    # -----------------------------
    # HORIZONTAL MOVEMENT
    if keys[pygame.K_a]:
        player_x -= VELOCITY
    if keys[pygame.K_d]:
        player_x += VELOCITY

    # Spieler-Rechteck aktualisieren
    player_rect = pygame.Rect(player_x, player_y, player_size, player_size)

    # Kollision mit Border prüfen
    if player_rect.colliderect(border_rect):
        # Wenn Spieler die Border berührt, zurücksetzen
        if keys[pygame.K_d]:  # nach rechts läuft
            player_x = border_rect.x - player_size
        elif keys[pygame.K_a]:  # nach links läuft
            player_x = border_rect.x + border_rect.width


    # GRAVITY
    player_y += velocity_y
    velocity_y += GRAVITY

    block = check_collision(player_x + scroll_x, player_y)
    if block:
        bx, by, bs, bc, trig = block
        player_y = by - player_size
        velocity_y = 0
        is_jumping = False

    player_rect = pygame.Rect(player_x, player_y, player_size, player_size)
    shop_rect_screen = pygame.Rect(shop_x - scroll_x, shop_y, shop_size, shop_size_)

    # Münzen einsammeln
    for coin in coins[:]:
        x, y, radius, value = coin
        coin_rect = pygame.Rect(x - scroll_x, y, radius*2, radius*2)
        if player_rect.colliderect(coin_rect):
            coin_count += value
            coins.remove(coin)
            coin_sound.play()

    # Gegner
    for enemy in enemies[:]:
        enemy["x"] += enemy["dir"] * 1.2
        enemy_rect = pygame.Rect(enemy["x"] - scroll_x, enemy["y"], 50, 50)

        if has_weapon and keys[pygame.K_SPACE] and player_rect.colliderect(enemy_rect):
            enemy["hp"] -= 1
            hit_sound.play()
            if enemy["hp"] <= 0:
                enemies.remove(enemy)
                coin_count += 5
        else:
            if player_rect.colliderect(enemy_rect):
                lives -= 1

    # TÜR
    door_rect_screen = pygame.Rect(door_rect.x - scroll_x, door_rect.y, door_rect.width, door_rect.height)
    if player_rect.colliderect(door_rect_screen):
        print("Level geschafft!")
        open_pause_menu()

    # -----------------------------
    # PLAYER ANIMATION UPDATEN
    # -----------------------------
    player_animation_timer += 1
    if player_animation_timer >= 8:
        player_animation_timer = 0
        player_frame_index = (player_frame_index + 1) % len(player_run_images)

    # -----------------------------
    # DRAW
    # -----------------------------
    screen.fill(BG)

    # Blöcke
    for bx, by, bs, bc, _ in blocks:
        pygame.draw.rect(screen, bc, (bx - scroll_x, by, bs, 20))

    # Münzen
    for coin in coins:
        x, y, radius, value = coin
        pygame.draw.circle(screen, GOLD, (int(x - scroll_x + player_size/2), int(y + player_size/2)), radius)

    # Gegner
    for enemy in enemies:
        screen.blit(villain_img, (enemy["x"] - scroll_x, enemy["y"]))

    # Spieler ANIMATION mit Spiegelung für links/rechts
    if is_jumping:
        player_image = player_jump_image
    else:
        if keys[pygame.K_a]:  # läuft nach links -> Bild spiegeln
            player_image = pygame.transform.flip(player_run_images[player_frame_index], True, False)
        elif keys[pygame.K_d]:  # läuft nach rechts
            player_image = player_run_images[player_frame_index]
        else:  # steht still
            player_image = player_idle_image

    screen.blit(player_image, (player_x, player_y))

    if has_weapon:
        screen.blit(sword_img, (player_x + player_size, player_y))

    # Tür
    screen.blit(door_image, (door_rect.x - scroll_x, door_rect.y))

    # Shop sichtbar
    pygame.draw.rect(screen, GOLD, shop_rect_screen)
    font = pygame.font.SysFont("Arial", 20)
    if player_rect.colliderect(shop_rect_screen.inflate(50, 50)):
        screen.blit(font.render("Drücke F für Shop", True, WHITE),
                    (shop_rect_screen.x, shop_rect_screen.y - 25))

    # HUD
    screen.blit(font.render(f"Leben: {lives}", True, WHITE), (10, 10))
    screen.blit(font.render(f"Coins: {coin_count}", True, WHITE), (10, 40))
    screen.blit(font.render(f"Waffe: {'JA' if has_weapon else 'NEIN'}", True, WHITE), (10, 70))

    if lives <= 0:
        game_over_sound.play()
        pygame.display.flip()
        pygame.time.delay(2000)
        running = False

    pygame.display.flip()

pygame.quit()
