import pygame
import random
import tkinter as tk
import time

pygame.init()
pygame.mixer.init()

# -----------------------------
# SOUNDS
# -----------------------------
jump_sound = pygame.mixer.Sound("sounds/fg/jump.wav")
jump_sound.set_volume(0.1)

coin_sound = pygame.mixer.Sound("sounds/fg/coins.wav")
coin_sound.set_volume(0.5)

hit_sound = pygame.mixer.Sound("sounds/fg/hit.wav")
hit_sound.set_volume(0.4)

pause_sound = pygame.mixer.Sound("sounds/fg/menue.wav")
pause_sound.set_volume(3.0)

game_over_sound = pygame.mixer.Sound("sounds/fg/gameover.wav")
game_over_sound.set_volume(10.0)

# -----------------------------
# SCREEN
# -----------------------------
SCREEN_WIDTH = 800
SCREEN_HEIGHT = 600
screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
pygame.display.set_caption("Elias 2D Game – LEVEL 4")

# -----------------------------
# COLORS (Düsteres Design)
# -----------------------------
BLUE = (0, 0, 255)
GREEN = (0, 255, 0)
WHITE = (255, 255, 255)
BG = (0, 0, 0)  # Schwarzer Hintergrund
GOLD = (255, 215, 0)
RED = (255, 0, 0)  # Rote Plattformen
LAVA = (255, 69, 0)

# -----------------------------
# PLAYER ANIMATION BILDER LADEN
# -----------------------------
player_run_images = [
    pygame.transform.scale(pygame.image.load("images/player_run1.png").convert_alpha(), (50, 50)),
    pygame.transform.scale(pygame.image.load("images/player_run2.png").convert_alpha(), (50, 50)),
    pygame.transform.scale(pygame.image.load("images/player_run3.png").convert_alpha(), (50, 50))
]

player_jump_image = pygame.transform.scale(pygame.image.load("images/player_jump.png").convert_alpha(), (50, 50))

player_idle_image = pygame.transform.scale(pygame.image.load("images/player_idle.png").convert_alpha(), (50, 50))

player_frame_index = 0
player_animation_timer = 0

# -----------------------------
# VARIABLEN DEFINITION
# -----------------------------
player_x = 100
player_y = 400
player_size = 50
VELOCITY = 3
GRAVITY = 0.5
velocity_y = 0
is_jumping = False
JUMP_STRENGTH = 15
lives = 3
coin_count = 0
has_weapon = False
has_better_jump = False

# -----------------------------
# ENEMY
# -----------------------------
enemies = [
    {"x": 600, "y": 400, "hp": 3, "dir": 1},
    {"x": 1200, "y": 380, "hp": 3, "dir": -1},
    {"x": 1800, "y": 420, "hp": 4, "dir": 1},
]

# -----------------------------
# COINS
# -----------------------------
def münze(x, y, value):
    return (x, y, 15, value)

coins = []
for i in range(20):
    x = random.randint(100, 2600)
    y = random.choice([360, 380, 400, 420])
    value = random.randint(6, 7)
    coins.append(münze(x, y, value))

# -----------------------------
# DOOR
# -----------------------------
door_image = pygame.image.load("images/tür.jpg").convert_alpha()
door_image = pygame.transform.scale(door_image, (50, 100))
door_rect = pygame.Rect(2600, 400, 50, 100)

# -----------------------------
# BLOCKS (Rote Plattformen)
# -----------------------------
blocks = []
level_length = 3000
x = 0
while x < level_length:
    platform_y = random.choice([420, 470, 520])
    if x % 450 < 140:
        blocks.append((x, 580, 140, BLUE, False))  # Wasser
    else:
        blocks.append((x, platform_y, 70, RED, False))  # Rote Plattformen
    x += 70

# -----------------------------
# COLLISION
# -----------------------------
def check_collision(x, y):
    for b in blocks:
        bx, by, bs, bc, trig = b
        if x + player_size > bx and x < bx + bs:
            if y + player_size >= by and y + player_size <= by + 10:
                return b
    return None

# -----------------------------
# PAUSE MENU
# -----------------------------
def open_pause_menu():
    pause = tk.Tk()
    pause.title("Pause")
    tk.Label(pause, text="PAUSE", font=("Arial", 18)).pack(pady=10)
    tk.Button(pause, text="Weiter", width=20, command=pause.destroy).pack(pady=5)
    tk.Button(pause, text="Exit", width=20, command=exit).pack(pady=5)
    pause.mainloop()

# -----------------------------
# MAIN LOOP
# -----------------------------
clock = pygame.time.Clock()
scroll_x = 0
running = True
while running:
    clock.tick(60)
    scroll_x += 0.7

    keys = pygame.key.get_pressed()
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            running = False
        if event.type == pygame.KEYDOWN:
            if event.key == pygame.K_p:
                open_pause_menu()
            if event.key == pygame.K_w and not is_jumping:
                velocity_y = -JUMP_STRENGTH
                is_jumping = True
                jump_sound.play()

    # MOVEMENT
    if keys[pygame.K_a]:
        player_x -= VELOCITY
    if keys[pygame.K_d]:
        player_x += VELOCITY

    # GRAVITY
    player_y += velocity_y
    velocity_y += GRAVITY

    block = check_collision(player_x + scroll_x, player_y)
    if block:
        bx, by, bs, bc, trig = block
        player_y = by - player_size
        velocity_y = 0
        is_jumping = False

    # -----------------------------
    # KOLLISION MIT GEGNERN (Der Spieler stirbt, wenn er die gleiche Höhe wie der Gegner hat)
    # -----------------------------
    player_rect = pygame.Rect(player_x, player_y, player_size, player_size)
    for enemy in enemies[:]:
        enemy["x"] += enemy["dir"] * 1.2
        enemy_rect = pygame.Rect(enemy["x"] - scroll_x, enemy["y"], 50, 50)

        if player_rect.colliderect(enemy_rect):  # Prüft horizontale und vertikale Kollision
            if abs(player_y - enemy["y"]) < 50:  # Prüft, ob der Spieler auf gleicher Höhe ist
                lives -= 1

    # COIN COLLECTING
    for coin in coins[:]:
        x, y, radius, value = coin
        coin_rect = pygame.Rect(x - scroll_x, y, radius * 2, radius * 2)
        if player_rect.colliderect(coin_rect):
            coin_count += value
            coins.remove(coin)
            coin_sound.play()

    # DOOR COLLISION
    door_rect_screen = pygame.Rect(door_rect.x - scroll_x, door_rect.y, door_rect.width, door_rect.height)
    if player_rect.colliderect(door_rect_screen):
        print("Level 4 completed!")
        open_pause_menu()

    # DRAW
    screen.fill(BG)  # Schwarzer Hintergrund

    for bx, by, bs, bc, _ in blocks:
        pygame.draw.rect(screen, bc, (bx - scroll_x, by, bs, 20))

    for coin in coins:
        x, y, radius, value = coin
        pygame.draw.circle(screen, GOLD, (int(x - scroll_x + player_size / 2), int(y + player_size / 2)), radius)

    # Player Animation
    if is_jumping:
        player_image = player_jump_image
    elif keys[pygame.K_a]:
        player_image = pygame.transform.flip(player_run_images[player_frame_index], True, False)
    elif keys[pygame.K_d]:
        player_image = player_run_images[player_frame_index]
    else:
        player_image = player_idle_image

    screen.blit(player_image, (player_x, player_y))

    # HUD
    font = pygame.font.SysFont("Arial", 20)
    screen.blit(font.render(f"Leben: {lives}", True, WHITE), (10, 10))
    screen.blit(font.render(f"Coins: {coin_count}", True, WHITE), (10, 40))

    if lives <= 0:
        game_over_sound.play()
        pygame.display.flip()
        pygame.time.delay(2000)
        running = False

    pygame.display.flip()

pygame.quit()
